/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import java.util.Map;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.table.EmptyFunctionTable;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.values.ImmutableValue;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;

public class ScopeValue
extends ImmutableValue {
    private IValueHolder[] symbolPage;
    private Map<String, ISymbolPageIdx> symbols;
    private SymbolScope scope;

    public static ScopeValue getInvalidValue(SymbolScope symbolScope) {
        ScopeValue scopeValue = new ScopeValue(symbolScope, null);
        scopeValue.setInvalid();
        return scopeValue;
    }

    public ScopeValue(SymbolScope symbolScope, IValueHolder[] iValueHolderArray) {
        this.scope = symbolScope;
        this.symbols = symbolScope.getLocalDefinedEntities();
        this.symbolPage = iValueHolderArray;
    }

    public SymbolScope getScope() {
        return this.scope;
    }

    public Object getRepresentation(int n) {
        return null;
    }

    @Override
    public String getType() {
        return "ScopeValue";
    }

    public IValueHolder[] getSymbolPage() {
        if (this.symbolPage == null) {
            this.symbolPage = this.scope.getSymbolTable().createPage();
        }
        return this.symbolPage;
    }

    @Override
    protected IValueHolder localGetVariable(String string, SourceRange sourceRange) {
        ISymbolPageIdx iSymbolPageIdx = this.symbols.get(string);
        if (iSymbolPageIdx == null || !iSymbolPageIdx.isScopeExposed()) {
            return null;
        }
        return iSymbolPageIdx.getValueHolder(this.getSymbolPage());
    }

    @Override
    public FunctionTable getFunctions() {
        return EmptyFunctionTable.instance;
    }
}

